// To parse this JSON data, do
//
//     final savingsDataResponseModel = savingsDataResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';

SavingsDataResponseModel savingsDataResponseModelFromJson(String str) => SavingsDataResponseModel.fromJson(json.decode(str));

String savingsDataResponseModelToJson(SavingsDataResponseModel data) => json.encode(data.toJson());

class SavingsDataResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final Data? data;

  SavingsDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SavingsDataResponseModel.fromJson(Map<String, dynamic> json) => SavingsDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  final Policies? policies;
  final List<Interval>? intervals;
  final List<Interval>? tenures;
  final List<String>? installmentAmounts;
  final List<Nominee>? nominee;
  final List<String>? otpTypes;
  final String? nomineeImagePath;

  Data({
    this.policies,
    this.intervals,
    this.tenures,
    this.installmentAmounts,
    this.nominee,
    this.nomineeImagePath,
    this.otpTypes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        policies: json["policies"] == null ? null : Policies.fromJson(json["policies"]),
        intervals: json["intervals"] == null ? [] : List<Interval>.from(json["intervals"]!.map((x) => Interval.fromJson(x))),
        tenures: json["tenures"] == null ? [] : List<Interval>.from(json["tenures"]!.map((x) => Interval.fromJson(x))),
        installmentAmounts: json["amounts"] == null ? [] : List<String>.from(json["amounts"]!.map((x) => x.toString())),
        nominee: json["nominees"] == null ? [] : List<Nominee>.from(json["nominees"]!.map((x) => Nominee.fromJson(x))),
        nomineeImagePath: json["nominee_image_path"],
        otpTypes: json['otp_types'] == null ? [] : List<String>.from(json['otp_types']!.map((x) => x.toString())),
      );

  Map<String, dynamic> toJson() => {
        "policies": policies?.toJson(),
        "intervals": intervals == null ? [] : List<dynamic>.from(intervals!.map((x) => x.toJson())),
        "tenures": tenures == null ? [] : List<dynamic>.from(tenures!.map((x) => x.toJson())),
        "amounts": installmentAmounts == null ? [] : List<dynamic>.from(installmentAmounts!.map((x) => x)),
        "nominees": nominee == null ? [] : List<dynamic>.from(nominee!.map((x) => x.toJson())),
        "nominee_image_path": nomineeImagePath,
      };
}

class Interval {
  final String? id;
  final String? name;
  final String? installmentInterval;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final String? duration;

  Interval({
    this.id,
    this.name,
    this.installmentInterval,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.duration,
  });

  factory Interval.fromJson(Map<String, dynamic> json) => Interval(
        id: json["id"].toString(),
        name: json["name"].toString(),
        installmentInterval: json["installment_interval"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        duration: json["duration"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "installment_interval": installmentInterval,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "duration": duration,
      };
}

class Policies {
  final String? description;

  Policies({
    this.description,
  });

  factory Policies.fromJson(Map<String, dynamic> json) => Policies(
        description: json["description"],
      );

  Map<String, dynamic> toJson() => {
        "description": description,
      };
}

class Nominee {
  final String? id;
  final String? userId;
  final String? nomineeName;
  final String? nomineeImage;
  final String? nomineeBirthDate;
  final List<NomineeData>? nomineeData;
  final String? createdAt;
  final String? updatedAt;

  Nominee({
    this.id,
    this.userId,
    this.nomineeName,
    this.nomineeImage,
    this.nomineeBirthDate,
    this.nomineeData,
    this.createdAt,
    this.updatedAt,
  });

  factory Nominee.fromJson(Map<String, dynamic> json) => Nominee(
        id: json["id"].toString(),
        userId: json["user_id"].toString(),
        nomineeName: json["nominee_name"].toString(),
        nomineeImage: json["nominee_image"].toString(),
        nomineeBirthDate: json["nominee_birth_date"].toString(),
        nomineeData: json["nominee_data"] == null ? [] : List<NomineeData>.from(json["nominee_data"]!.map((x) => NomineeData.fromJson(x))),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "nominee_name": nomineeName,
        "nominee_image": nomineeImage,
        "nominee_birth_date": nomineeBirthDate,
        "nominee_data": nomineeData == null ? [] : List<dynamic>.from(nomineeData!.map((x) => x.toJson())),
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class NomineeData {
  final String? name;
  final String? type;
  final String? value;

  NomineeData({
    this.name,
    this.type,
    this.value,
  });

  factory NomineeData.fromJson(Map<String, dynamic> json) => NomineeData(
        name: json["name"],
        type: json["type"],
        value: json["value"],
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "type": type,
        "value": value,
      };
}
